/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.interpolators.KBCubicSplineSegment;
import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;

public class KBCubicSplineCurve {
    private float totalCurveLength;
    private KBCubicSplineSegment[] cubicSplineSegment;
    public int numSegments;

    KBCubicSplineCurve() {
        this.numSegments = 0;
        this.totalCurveLength = 0.0f;
    }

    KBCubicSplineCurve(KBKeyFrame[] kBKeyFrameArray) {
        int n2 = kBKeyFrameArray.length;
        if (n2 < 4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBCubicSplineCurve0"));
        }
        this.numSegments = n2 - 3;
        this.cubicSplineSegment = new KBCubicSplineSegment[this.numSegments];
        int n3 = 0;
        int n4 = 1;
        int n5 = 2;
        int n6 = 3;
        while (n3 < this.numSegments) {
            this.cubicSplineSegment[n3] = new KBCubicSplineSegment(kBKeyFrameArray[n3], kBKeyFrameArray[n4], kBKeyFrameArray[n5], kBKeyFrameArray[n6]);
            ++n3;
            ++n4;
            ++n5;
            ++n6;
        }
        this.computeTotalCurveLength();
    }

    KBCubicSplineCurve(KBCubicSplineSegment[] kBCubicSplineSegmentArray) {
        this.cubicSplineSegment = new KBCubicSplineSegment[kBCubicSplineSegmentArray.length];
        this.numSegments = this.cubicSplineSegment.length;
        for (int i2 = 0; i2 < this.numSegments; ++i2) {
            this.cubicSplineSegment[i2] = kBCubicSplineSegmentArray[i2];
        }
        this.computeTotalCurveLength();
    }

    public void setSegments(KBCubicSplineSegment[] kBCubicSplineSegmentArray) {
        this.cubicSplineSegment = new KBCubicSplineSegment[kBCubicSplineSegmentArray.length];
        this.numSegments = this.cubicSplineSegment.length;
        for (int i2 = 0; i2 < this.numSegments; ++i2) {
            this.cubicSplineSegment[i2] = kBCubicSplineSegmentArray[i2];
        }
        this.computeTotalCurveLength();
    }

    public KBCubicSplineSegment getSegment(int n2) {
        return this.cubicSplineSegment[n2];
    }

    private void computeTotalCurveLength() {
        this.totalCurveLength = 0.0f;
        for (int i2 = 0; i2 < this.numSegments; ++i2) {
            this.totalCurveLength += this.cubicSplineSegment[i2].length;
        }
    }

    public float getTotalCurveLength() {
        return this.totalCurveLength;
    }
}

